#include "AudioStack/SMT/clSrcState.h"
#include "AudioStack/SMT/clSrcStateFactory.h"
#include "AudioStack/clAudioSource.h"

#ifndef USE_DLT_TRACE
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_COMP_AUDIOSTACK
#include "trcGenProj/Header/clSrcState.cpp.trc.h"
#endif


namespace AudioStack
{



clSrcState::clSrcState(const tChar* pacName, AudioStates::enAudioStates enStateID)
{
   m_pacName = pacName;
   m_enStateID = enStateID;
   m_u32UserData = 0;
  m_bTrace = 0;
}
clSrcState::~clSrcState()
{
   m_pacName = NULL;
  m_bTrace = 0;
  m_transitionCollection.clear();
}

tVoid clSrcState::vSetTransition(enTrigger trigger, clSrcState* targetState)
{
   m_transitionCollection[trigger] = targetState;
}

tVoid clSrcState::vHandleTrigger(clSrcState::enTrigger trigger, clAudioSource* pclAudioSource, tU32 u32UserData)
{
   if(pclAudioSource != NULL)
   {
//   ETG_TRACE_USR4(("Source:%d, Incoming Trigger %d in State %s",
//               ETG_ENUM(AudioSources::enAudioSources, static_cast<AudioSources::enAudioSources>(pclAudioSource->m_u8Id)),
//               ETG_ENUM(clSrcState::enTrigger, trigger),
//               m_pacName));
   }else{
      ETG_TRACE_ERR(("ERROR: SRC IS NULL"));
   }
   bpstl::map<clSrcState::enTrigger, clSrcState* >::iterator iter = m_transitionCollection.find(trigger);
   if(iter != m_transitionCollection.end())
   {
      vSetState(pclAudioSource, iter->second, u32UserData);
   }else{
      ETG_TRACE_USR4(("Trigger %d not handled in State %s",
            ETG_CENUM(clSrcState::enTrigger, trigger),
            m_pacName));
   }
}


tVoid clSrcState::vSetState(clAudioSource* pclAudioSource, clSrcState* pclState, tU32 u32UserData)
{
   vSetState(pclAudioSource, pclState, u32UserData, ENTRYCONDITION_NONE);
}

tVoid clSrcState::vSetState(clAudioSource* pclAudioSource, clSrcState* pclState, tU32 u32UserData, tU8 enEntryCondition)
{
   if((pclAudioSource != NULL) && (pclAudioSource->m_pclState != NULL))
   {
      ETG_TRACE_USR4(("vSetState: Src:%d SubID: 0x%x, OldState:%20s, NewState %s",
            ETG_CENUM(AudioSources::enAudioSources, static_cast<AudioSources::enAudioSources>(pclAudioSource->sGetId().enSourceClass)),
            pclAudioSource->sGetId().u16SubSource,
            pclAudioSource->m_pclState->m_pacName,
            pclState->m_pacName));
   }else{
      ETG_TRACE_ERR(("ERROR: SRC IS NULL"));
   }
   pclAudioSource->m_pclState = pclState;
   pclAudioSource->m_pclState->vEnter(pclAudioSource, u32UserData, enEntryCondition);
}
void clSrcState::vEnter(clAudioSource* , tU32 , tU8 )
{}

tVoid clSrcState::vMsg_On(clAudioSource* src, tU32 u32UserData)
{
   vHandleTrigger(clSrcState::On, src, u32UserData);
}
tVoid clSrcState::vMsg_WaitFor(clAudioSource* , tU32 )
{}

tVoid clSrcState::vMsg_OnDone(clAudioSource* , tU32 )
{}

tVoid clSrcState::vMsg_Off(clAudioSource* src, tU32 u32UserData)
{
   vHandleTrigger(clSrcState::Off, src, u32UserData);
}

tVoid clSrcState::vMsg_OffDone(clAudioSource* , tU32 )
{}

tVoid clSrcState::vMsg_Pause(clAudioSource* src, tU32 u32UserData)
{
   vHandleTrigger(clSrcState::Pause, src, u32UserData);
}

tVoid clSrcState::vMsg_PauseDone(clAudioSource* , tU32 )
{}

tVoid clSrcState::vMsg_Init(clAudioSource* , tU32 )
{}

tVoid clSrcState::vMsg_InitDone(clAudioSource* , tU32 )
{}

tVoid clSrcState::vMsg_ServiceAvailable(clAudioSource* , tU32 )
{}

tVoid clSrcState::vMsg_ServiceUnavailable(clAudioSource* , tU32 )
{}

tVoid clSrcState::vMsg_RequestConfirmed(clAudioSource* , tU32 )
{}

tVoid clSrcState::vMsg_SrcAvailabilityChg(clAudioSource* src, tU32 u32UserData)
{
   vHandleTrigger(clSrcState::SrcAvailabilityChg, src, u32UserData);
}

}//namespace


